import pygame
import random
import math

from OpenGL.GL import *
from OpenGL.GLU import *

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 12 Display Lists"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    #instance variables to be replaced with objects
    self.boxdlist = None
    self.topdlist = None
    self.cuberot = [0,0]
    self.colors_light = [[1,0,0],[1,.5,0],[1,1,0],[0,1,0],[0,1,1]]
    self.colors_dark = [[.5,0.0,0.0],[0.5,0.25,0.0],[0.5,0.5,0.0],[0.0,0.5,0.0],[0.0,0.5,0.5]]
  def build_lists(self):
    box = glGenLists(2)
    glNewList(box,GL_COMPILE)
    glBegin(GL_QUADS)
    #front
    glTexCoord2d(0,0);glVertex3f(-1,-1,1)
    glTexCoord2d(1,0);glVertex3f(1,-1,1)
    glTexCoord2d(1,1);glVertex3f(1,1,1)
    glTexCoord2d(0,1);glVertex3f(-1,1,1)
    #right
    glTexCoord2d(0,0);glVertex3f(1,-1,1)
    glTexCoord2d(1,0);glVertex3f(1,-1,-1)
    glTexCoord2d(1,1);glVertex3f(1,1,-1)
    glTexCoord2d(0,1);glVertex3f(1,1,1)
    #back
    glTexCoord2d(0,0);glVertex3f(1,-1,-1)
    glTexCoord2d(1,0);glVertex3f(-1,-1,-1)
    glTexCoord2d(1,1);glVertex3f(-1,1,-1)
    glTexCoord2d(0,1);glVertex3f(1,1,-1)
    #left
    glTexCoord2d(0,0);glVertex3f(-1,-1,-1)
    glTexCoord2d(1,0);glVertex3f(-1,-1,1)
    glTexCoord2d(1,1);glVertex3f(-1,1,1)
    glTexCoord2d(0,1);glVertex3f(-1,1,-1)
    #bottom
    glTexCoord2d(0,0);glVertex3f(-1,-1,-1)
    glTexCoord2d(1,0);glVertex3f(1,-1,-1)
    glTexCoord2d(1,1);glVertex3f(1,-1,1)
    glTexCoord2d(0,1);glVertex3f(-1,-1,1)
    glEnd()
    glEndList()
    top = box+1
    glNewList(top,GL_COMPILE)
    glBegin(GL_QUADS)
    #top
    glTexCoord2d(0,0);glVertex3f(-1,1,1)
    glTexCoord2d(1,0);glVertex3f(1,1,1)
    glTexCoord2d(1,1);glVertex3f(1,1,-1)
    glTexCoord2d(0,1);glVertex3f(-1,1,-1)
    glEnd()
    glEndList()
    self.boxdlist = box
    self.topdlist = top
  def initGL(self):
    if not self.texloaded: self.loadGLTextures()
    if not self.topdlist: self.build_lists()
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    glEnable(GL_LIGHT0)
    glEnable(GL_LIGHTING)
    glEnable(GL_COLOR_MATERIAL)
    #self.glinited = True
  def loadGLTextures(self):
    self.textures.append(pygame.image.load("Data/Cube.bmp"))
    idat = pygame.image.tostring(self.textures[0],"RGB",True)
    self.tnames = glGenTextures(2)
    if not hasattr(self.tnames,"__len__"):
      self.tnames = (self.tnames,)
    #linear filter
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    glTexImage2D(GL_TEXTURE_2D,0,3,self.textures[0].get_width(),self.textures[0].get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
    #self.texloaded = True
    self.textures = []
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    for y in range(1,6):
      for x in range(0,y):
        glLoadIdentity()
        glTranslatef(x*2.8+1.4-y*1.4,(6-y)*2.4-7,-20)
        glRotatef(45,1,0,0)
        glRotatef(45,0,1,0)
        glColor3fv(self.colors_light[y-1])
        glCallList(self.boxdlist)
        glColor3fv(self.colors_dark[y-1])
        glCallList(self.topdlist)

screen = Screen()
screen.resize()

piover180 = math.pi/180.0
running = 1
c = pygame.time.Clock()
while running:
  c.tick(60)
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
  keys = pygame.key.get_pressed()
  if keys[pygame.K_PAGEUP]:
    pass
  if keys[pygame.K_PAGEDOWN]:
    pass
  if keys[pygame.K_RIGHT]:
    pass
  if keys[pygame.K_LEFT]:
    pass
  if keys[pygame.K_UP]:
    pass
  if keys[pygame.K_DOWN]:
    pass
